<?php

namespace Netzperfekt\SaasDeadman\Filament\OnBoarding;

use RalphJSmit\Filament\Onboard\FilamentOnboard;
use RalphJSmit\Filament\Onboard\Step;
use RalphJSmit\Filament\Onboard\Track;

class OnBoarding
{
    public static function getOnboarding()
    {
        return FilamentOnboard::make()
            ->prefix('start')
            ->addTrack(fn() =>
                Track::make([
                    Step::make(name: 'Connect Notion', identifier: 'widget::connect-notion')
                        ->description('Sign in with Notion and grant access to your workspace.')
                        ->icon('heroicon-o-check-circle')
                        ->performStepActionLabel('Add workspace →')
                        ->url('https://spiegel.de')->urlShouldOpenInNewTab()
                        ->columnSpan(3),
                ])
            );
    }
}
