<?php

namespace Netzperfekt\SaasDeadman\Filament\Resources\ChannelResource;

use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Split;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Support\Colors\Color;
use Filament\Support\Enums\FontWeight;
use Filament\Support\Enums\IconSize;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Validation\Rules\Unique;
use Netzperfekt\SaasDeadman\Enums\ChannelType;
use Netzperfekt\SaasDeadman\Filament\Resources\ChannelResource\Pages\CreateChannel;
use Netzperfekt\SaasDeadman\Filament\Resources\ChannelResource\Pages\EditChannel;
use Netzperfekt\SaasDeadman\Filament\Resources\ChannelResource\Pages\ListChannels;
use Netzperfekt\SaasDeadman\Models\Channel;

class ChannelResource extends Resource
{
    protected static ?string $model = Channel::class;
    protected static bool $isScopedToTenant = false;

    protected static ?string $navigationIcon = 'fas-bullhorn';
    protected static ?string $recordTitleAttribute = 'title';
    protected static ?int $navigationSort = -9;

    public static function getNavigationGroup(): ?string
    {
        return __('deadman-navigation-group');
    }

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }

    public static function getModelLabel(): string
    {
        return __('deadman-channel');
    }

    public static function getPluralModelLabel(): string
    {
        return __('deadman-channels');
    }

    public static function getGlobalSearchResultDetails(Model $record): array
    {
        return [
            'Typ' => $record->type->getLabel()
        ];
    }

    public static function form(Form $form): Form
    {
        return $form
            ->columns(1)
            ->schema([
                Split::make([
                    Section::make()
                        ->schema([
                            Grid::make()
                                ->columns(4)
                                ->schema([
                                    TextInput::make('key')
                                        ->label(__('deadman-key'))
                                        ->required()
                                        ->unique(
                                            ignoreRecord: true,
                                            modifyRuleUsing: function (Unique $rule, $state)
                                            {
                                                return $rule->where('key', $state);
                                            }
                                        )
                                        ->maxLength(25)
                                        ->autofocus(),

                                    TextInput::make('title')
                                        ->label(__('deadman-title'))
                                        ->required()
                                        ->maxLength(255)
                                ]),

                            Textarea::make('description')
                                ->label(__('deadman-description'))
                                ->rows(5)
                        ])
                        ->grow(),

                    Section::make([
                        Toggle::make('active')
                            ->label(__('deadman-active'))
                            ->default(true)
                            ->onColor(Color::Green)
                            ->offColor(Color::Red),

                        Select::make('type')
                            ->label(__('deadman-type'))
                            ->options(ChannelType::class)
                            ->required()
                            ->live()

                    ])->grow(false)
                ])->from('xl')
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('title')
                    ->label(__('deadman-title'))
                    ->weight(FontWeight::SemiBold)
                    ->searchable(),

                Tables\Columns\TextColumn::make('key')
                    ->label(__('deadman-key'))
                    ->searchable(),

                Tables\Columns\TextColumn::make('type')
                    ->label(__('deadman-type'))
                    ->badge(),

                Tables\Columns\TextColumn::make('switches_count')
                    ->counts('switches')
                    ->label(__('deadman-switches-count'))
                    ->badge(),

                Tables\Columns\ToggleColumn::make('active')
                    ->label(__('deadman-active'))
                    ->disabled()
                    ->onColor(Color::Green)
                    ->offColor(Color::Red)
            ])

            ->filters([
                Tables\Filters\TrashedFilter::make(),

                Tables\Filters\SelectFilter::make('type')
                    ->label(__('deadman-type'))
                    ->options(ChannelType::class)
            ])

            ->actions([
                /* TODO kann raus - ggf. code noch konservieren
                Tables\Actions\Action::make('send_test')
                    ->label(__('deadman-send-test'))
                    ->iconButton()
                    ->tooltip(__('deadman-send-test'))
                    ->icon('heroicon-o-envelope')
                    ->requiresConfirmation()
                    ->action(function (Channel $channel)
                    {
                        $firstSwitch = $channel->switches->first();
                        $channelWithPivot = $firstSwitch->channels->filter(fn($c) => $c->id == $channel->id)->first();

                        $count = SwitchService::sendTestNotifications($firstSwitch, $channelWithPivot);

                        if($count > 0)
                        {
                            Notification::make()
                                ->title(__('deadman-notification-sent', ['count' => $count]))
                                ->success()
                                ->send();
                        }
                        else {
                            Notification::make()
                                ->title(__('deadman-notification-notsent'))
                                ->danger()
                                ->send();
                        }
                    }),
                */

                Tables\Actions\EditAction::make()->iconButton()->tooltip('Bearbeiten'),
                Tables\Actions\DeleteAction::make()->iconButton()->tooltip('Löschen'),
                Tables\Actions\ForceDeleteAction::make()->iconButton()->tooltip('Endgültig löschen'),
                Tables\Actions\RestoreAction::make()->iconButton()->tooltip('Wiederherstellen')
            ])

            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                    Tables\Actions\ForceDeleteBulkAction::make(),
                ]),
            ])

            ->emptyStateActions([
                Tables\Actions\CreateAction::make(),
            ])

            ->defaultSort('title');
    }

    public static function getRelations(): array
    {
        return [
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListChannels::route('/'),
            'create' => CreateChannel::route('/create'),
            'edit' => EditChannel::route('/{record}/edit'),
        ];
    }

    public static function getEloquentQuery(): \Illuminate\Database\Eloquent\Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
