<?php

namespace Netzperfekt\SaasDeadman\Filament\Resources\ContactResource\RelationManagers;

use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Split;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Support\Colors\Color;
use Filament\Support\Enums\IconSize;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Netzperfekt\SaasDeadman\Enums\ContactType;

class NotificationTargetsRelationManager extends RelationManager
{
    protected static string $relationship = 'notificationTargets';

    public static function canViewForRecord(Model $ownerRecord, string $pageClass): bool
    {
        return $ownerRecord->type != ContactType::Myself;
    }

    public function form(Form $form): Form
    {
        return $form
            ->columns(1)
            ->schema($this->getPivotFormSchema());
    }

    private function getPivotFormSchema(): array
    {
        return [
            Split::make([
                Section::make([
                    TextInput::make('subject')
                        ->label(__('deadman-subject'))
                        ->required(),

                    Textarea::make('template')
                        ->label(__('deadman-template'))
                        ->required(),
                ])->compact(),

                Section::make([
                    Toggle::make('active')
                        ->label(__('deadman-active'))
                        ->default(true)
                        ->onColor(Color::Green)
                        ->offColor(Color::Red)
                ])
                    ->compact()
                    ->grow(false)
            ])->from('xl')
        ];
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('title')
            ->allowDuplicates()
            ->columns([
                Tables\Columns\TextColumn::make('subject')
                    ->label(__('deadman-subject'))
                    ->sortable()
                    ->searchable(),

                Tables\Columns\TextColumn::make('title')
                    ->label(__('deadman-channel'))
                    ->sortable()
                    ->searchable(),

                Tables\Columns\ToggleColumn::make('active')
                    ->label(__('deadman-active'))
                    ->onColor(Color::Green)
                    ->offColor(Color::Red)
                    ->disabled()
            ])

            ->filters([
                //
            ])

            ->headerActions([
                Tables\Actions\AttachAction::make()
                    ->preloadRecordSelect()
                    ->recordSelect(
                        fn (Select $select) => $select->placeholder('Benachrichtigungsziel auswählen')
                    )
                    ->recordSelectOptionsQuery(fn(Builder $query) => $query->onlyMyRecords())
                    ->form(fn (Tables\Actions\AttachAction $action): array => [
                        $action->getRecordSelect(),
                        ...$this->getPivotFormSchema(),
                    ])
                ->modalWidth('2xl')
            ])

            ->actions([
                Tables\Actions\EditAction::make()
                    ->label('')
                    ->tooltip('Bearbeiten')
                    ->iconSize(IconSize::Medium),

                Tables\Actions\DetachAction::make()
                    ->label('')
                    ->tooltip('Trennen')
                    ->iconSize(IconSize::Medium)
            ])

            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DetachBulkAction::make()
                ]),
            ])

            ->defaultSort('sort_order', 'asc')
            ->reorderable('sort_order', true)
            ->reorderRecordsTriggerAction(
                fn (Tables\Actions\Action $action, bool $isReordering) => $action
                    ->button()
                    ->label($isReordering ? __('deadman-sort-save') : __('deadman-sort'))
                    ->color($isReordering ? 'warning' : 'gray')
            );
    }
}
