<?php

namespace Netzperfekt\SaasDeadman\Filament\Resources\SwitchResource;

use Filament\Actions;
use Filament\Notifications\Notification;
use Netzperfekt\SaasDeadman\Facades\SwitchService;
use Netzperfekt\SaasDeadman\Models\DMSwitch;
use Netzperfekt\SaasDeadman\States\SwitchGracePeriod;
use Netzperfekt\SaasDeadman\States\SwitchMustConfirm;

class ConfirmAction
{
    public static function getAction(DMSwitch $switch): Actions\Action
    {
       return Actions\Action::make('confirm-now')
           ->label(__('deadman-confirm-now'))
           ->tooltip(__('deadman-confirm-now'))
           ->icon('heroicon-o-check')
           ->color('success')
           ->visible(fn() => $switch->state->equals(SwitchMustConfirm::class) || $switch->state->equals(SwitchGracePeriod::class))
           ->requiresConfirmation()

           ->action(function () use ($switch)
           {
               SwitchService::setConfirmed($switch, 'backend');

               redirect(SwitchResource::getUrl('edit', [$switch->id]));

               Notification::make()
                   ->title(__('deadman-switch-confirmed'))
                   ->success()
                   ->send();
           });
    }
}
