<?php

namespace Netzperfekt\SaasDeadman\Filament\Resources\SwitchResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Netzperfekt\SaasBase\Traits\HasEditPageActions;
use Netzperfekt\SaasDeadman\Filament\Resources\SwitchResource\ConfirmAction;
use Netzperfekt\SaasDeadman\Filament\Resources\SwitchResource\ReleaseAction;
use Netzperfekt\SaasDeadman\Filament\Resources\SwitchResource\ResetAction;
use Netzperfekt\SaasDeadman\Filament\Resources\SwitchResource\SwitchResource;

class EditSwitch extends EditRecord
{
    use HasEditPageActions;

    protected static string $resource = SwitchResource::class;

    protected function getHeaderActions(): array
    {
        return [
            ConfirmAction::getAction($this->record),
            ReleaseAction::getAction($this->record),
            ResetAction::getAction($this->record),

            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        unset($data['next_confirmation']); // readonly - nicht speichern, kann "-" etc. enthalten

        return $data;
    }
}
