<?php

namespace Netzperfekt\SaasDeadman\Filament\Resources\SwitchResource;

use Filament\Actions;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Notifications\Notification;
use Illuminate\Support\HtmlString;
use Netzperfekt\SaasDeadman\Enums\ActivityLogType;
use Netzperfekt\SaasDeadman\Models\DMSwitch;
use Netzperfekt\SaasDeadman\States\SwitchTriggered;

class ReleaseAction
{
    public static function getAction(DMSwitch $switch): Actions\Action
    {
        return Actions\Action::make('release-switch')
            ->disabled(fn() => $switch->state->equals(SwitchTriggered::class) || !$switch->isActive())
            ->visible(fn() => ! $switch->state->equals(SwitchTriggered::class))
            ->label(__('deadman-switch-trigger'))
            ->icon('fas-land-mine-on')
            ->color('warning')
            ->requiresConfirmation()
            ->modalIcon('fas-land-mine-on')
            ->modalIconColor('warning')
            ->modalHeading(__('deadman-switch-trigger-header'))
            ->modalDescription(new HtmlString(__('deadman-switch-trigger-description', ['switch' => $switch->title])))
            ->modalSubmitActionLabel(__('deadman-switch-trigger-now'))

            ->form([
                TextInput::make('release-switch-confirm-text')
                    ->label(__('deadman-switch-trigger-confirm-text'))
                    ->placeholder(__('deadman-switch-trigger-confirm-text-placeholder')),

                Toggle::make('release-switch-confirmed')
                    ->label(__('deadman-switch-trigger-confirmed'))
                    ->onIcon('fas-land-mine-on')
                    ->onColor('danger')
            ])

            ->action(function($data) use ($switch)
            {
                $confirmed = strtolower(trim($data['release-switch-confirm-text'])) == strtolower(trim($switch->title)) &&
                             $data['release-switch-confirmed'];

                if(!$confirmed)
                {
                    Notification::make()
                        ->title(__('deadman-switch-trigger-canceled'))
                        ->warning()
                        ->send();

                    return;
                }

                $switch->state->transitionTo(SwitchTriggered::class, true); // force allow transition to 'triggered'

                activity()
                    ->performedOn($switch)
                    ->withProperties(['source' => 'backend'])
                    ->log(ActivityLogType::SwitchTriggered->value);

                redirect(SwitchResource::getUrl('edit', [$switch->id]));

                Notification::make()
                    ->title(__('deadman-switch-triggered'))
                    ->success()
                    ->send();
            });
    }
}
