<?php

namespace Netzperfekt\SaasDeadman\Filament\Resources\SwitchResource;

use Filament\Actions;
use Filament\Notifications\Notification;
use Netzperfekt\SaasDeadman\Facades\SwitchService;
use Netzperfekt\SaasDeadman\Models\DMSwitch;
use Netzperfekt\SaasDeadman\States\SwitchTriggered;

class ResetAction
{
    public static function getAction(DMSwitch $switch): Actions\Action
    {
        return Actions\Action::make('resetState')
            ->label(__('deadman-reset-state'))
            ->icon('fas-power-off')
            ->color('info')
            ->tooltip(__('deadman-reset-state'))
            ->requiresConfirmation()
            ->visible(fn() => $switch->state->equals(SwitchTriggered::class))

            ->action(function () use ($switch)
            {
                SwitchService::setIdle($switch, 'backend');

                $switch->next_confirmation = null; // der schalter ist sofort wieder zu bestätigen
                $switch->save();

                redirect(SwitchResource::getUrl('edit', [$switch->id]));

                Notification::make()
                    ->title(__('deadman-switch-resetted'))
                    ->success()
                    ->send();
            });
    }
}
