<?php

namespace Netzperfekt\SaasDeadman\Filament\Widgets;

use Filament\Facades\Filament;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Netzperfekt\SaasDeadman\Filament\Resources\ChannelResource\ChannelResource;
use Netzperfekt\SaasDeadman\Filament\Resources\ContactResource\ContactResource;
use Netzperfekt\SaasDeadman\Filament\Resources\ActionResource\ActionResource;
use Netzperfekt\SaasDeadman\Filament\Resources\SwitchResource\SwitchResource;
use Netzperfekt\SaasDeadman\Models\Channel;
use Netzperfekt\SaasDeadman\Models\Contact;
use Netzperfekt\SaasDeadman\Models\DMSwitch;
use Netzperfekt\SaasDeadman\Models\Action;

class DeadmanOverviewWidget extends BaseWidget
{
    protected function getStats(): array
    {
        $ownContact = Contact::onlyMyRecords()->ownContact()->first();
        $contactsCount = Contact::onlyMyRecords()->count();
        $notificationsCount = Action::onlyMyRecords()->count();
        $switchesCount = DMSwitch::onlyMyRecords()->count();

        $stats = [];

        $contactDescription = '';
        if($ownContact)
        {
            $contactDescription = __('deadman-overview-own-contact') . ': ' .
                                  $ownContact->firstname . ' ' .
                                  $ownContact->lastname;
        }

        if(Filament::getCurrentPanel()->getId() == 'admin')
        {
            $stats[] = Stat::make(__('deadman-overview-channels'), Channel::count())
                ->icon('fas-bullhorn')
                ->url(ChannelResource::getUrl('index'));
        }

        $stats[] = Stat::make(__('deadman-overview-contacts'), $contactsCount)
            ->description($contactDescription)
            ->icon('heroicon-o-building-office')
            ->url(ContactResource::getUrl('index'));

        $stats[] = Stat::make(__('deadman-overview-actions'), $notificationsCount)
            ->icon('far-envelope')
            ->url(ActionResource::getUrl('index'));

        $stats[] = Stat::make(__('deadman-overview-switches'), $switchesCount)
            ->icon('fas-toggle-off')
            ->url(SwitchResource::getUrl('index'));

        return $stats;
    }
}
