<?php

namespace Netzperfekt\SaasDeadman\Filament\Widgets;

use Filament\Support\Enums\FontWeight;
use Filament\Support\Enums\IconSize;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Netzperfekt\SaasDeadman\Enums\SwitchStateEnum;
use Netzperfekt\SaasDeadman\Filament\Resources\SwitchResource\SwitchResource;
use Netzperfekt\SaasDeadman\Models\DMSwitch;
use Netzperfekt\SaasDeadman\States\SwitchGracePeriod;

class SwitchesToBeConfirmedWidget extends BaseWidget
{
    public function table(Table $table): Table
    {
        return $table
            ->searchable(false)
            ->paginated(false)
            ->heading(fn(Table $table): string => $table->getQuery()->count() . ' ' . __('deadman-widget-switches-confirm'))
            ->emptyStateHeading(__('deadman-widget-no-switches-confirm'))
            ->emptyStateIcon('fas-check')

            ->query(
                DMSwitch::query()
                    ->onlyMyRecords()
                    ->active()
                    ->notPaused()
                    ->mustConfirmOrGrace()
                    ->orderBy('next_confirmation', 'DESC')
            )

            ->columns([
                Tables\Columns\TextColumn::make('title')
                    ->label(__('deadman-title'))
                    ->weight(FontWeight::SemiBold)
                    ->tooltip(fn($record) => $record->description)
                    ->searchable(),

                Tables\Columns\TextColumn::make('state')
                    ->label(__('deadman-state'))
                    ->formatStateUsing(fn($record) => SwitchStateEnum::from($record->state)->getLabel())
                    ->badge()
                    ->tooltip(function ($record)
                    {
                        return __('deadman-must-confirm-until', [
                            'confirmation-due-date' => $record?->confirmUntil?->formatWithTimezone(FORMAT_DISPLAY_DATETIME) ?? '---',
                            'confirmation-date' => $record?->confirmUntil?->formatWithTimezone(FORMAT_DISPLAY_DATETIME) ?? '---'
                        ]);
                    }),

                Tables\Columns\TextColumn::make('next_confirmation')
                    ->label(__('deadman-widget-switches-confirm-until'))
                    ->formatStateUsing(fn($record) => $record?->confirmUntil?->formatWithTimezone(FORMAT_DISPLAY_DATETIME) ?? '---')
            ])

            ->actions([
                Tables\Actions\EditAction::make()->iconButton()->tooltip('Bearbeiten')
                    ->url(fn (DMSwitch $switch): string => SwitchResource::getUrl('edit', ['record' => $switch]))
            ])

            ->recordClasses(fn(DMSwitch $switch) => SwitchStateEnum::from($switch->state)->getBackgroundColor());
    }
}
