<?php

namespace Netzperfekt\SaasDeadman\Filament\Widgets;

use Filament\Support\Enums\FontWeight;
use Filament\Support\Enums\IconSize;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Netzperfekt\SaasDeadman\Enums\SwitchStateEnum;
use Netzperfekt\SaasDeadman\Filament\Resources\SwitchResource\SwitchResource;
use Netzperfekt\SaasDeadman\Models\DMSwitch;

class SwitchesTriggeredWidget extends BaseWidget
{
    public function table(Table $table): Table
    {
        return $table
            ->searchable(false)
            ->paginated(false)
            ->heading(fn(Table $table): string => $table->getQuery()->count() . ' ' . __('deadman-widget-switches-triggered'))
            ->emptyStateHeading(__('deadman-widget-no-switches-triggered'))
            ->emptyStateIcon('fas-check')

            ->query(
                DMSwitch::onlyMyRecords()
                    ->active()
                    ->notPaused()
                    ->triggered()
                    ->orderBy('triggered_at', 'DESC')
            )

            ->columns([
                Tables\Columns\TextColumn::make('title')
                    ->label(__('deadman-title'))
                    ->weight(FontWeight::SemiBold)
                    ->tooltip(fn($record) => $record->description)
                    ->searchable(),

                Tables\Columns\TextColumn::make('state')
                    ->label(__('deadman-state'))
                    ->formatStateUsing(fn($record) => SwitchStateEnum::from($record->state)->getLabel())
                    ->badge(),

                Tables\Columns\TextColumn::make('triggered_at')
                    ->label(__('deadman-triggered-at'))
                    ->formatStateUsing(fn($record) => $record?->triggered_at?->formatWithTimezone(FORMAT_DISPLAY_DATETIME) ?? '---')
            ])

            ->actions([
                Tables\Actions\EditAction::make()->iconButton()->tooltip('Bearbeiten')
                    ->url(fn (DMSwitch $switch): string => SwitchResource::getUrl('edit', ['record' => $switch]))
            ])

            ->recordClasses(fn(DMSwitch $switch) => SwitchStateEnum::from($switch->state)->getBackgroundColor());
    }
}
