<?php

namespace Netzperfekt\SaasDeadman\Models;

use Database\Factories\ActionFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasBase\Traits\HasDefaultScopes;
use Netzperfekt\SaasBase\Traits\HasGlobalModelObserver;
use Netzperfekt\SaasDeadman\Casts\EncryptedCast;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Netzperfekt\SaasDeadman\Enums\ActionType;

class Action extends Model
{
    use HasFactory;
    use SoftDeletes;
    use HasGlobalModelObserver;
    use HasDefaultScopes;

    protected $table = 'deadman_actions';

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at',
        'team_id',
        'type',
        'encrypted',
        'subject',
        'contents',
        'attach_contents'
    ];

    protected $casts = [
        'contents' => EncryptedCast::class,
        'type' => ActionType::class
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function switches(): BelongsToMany
    {
        return $this->belongsToMany(
            DMSwitch::class,
            'deadman_switch_actions',
            'switch_id',
            'action_id',
        )
            ->withPivot(['id', 'channel_id', 'notification_contacts', 'notification_sent'])
            ->withCasts(['notification_contacts' => 'array'])
            ->using(SwitchActions::class);
    }

    protected static function newFactory(): Factory
    {
        return ActionFactory::new();
    }
}
