<?php

namespace Netzperfekt\SaasDeadman\Models;

use Database\Factories\ChannelFactory;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Netzperfekt\SaasDeadman\Enums\ChannelType;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Channel extends Model
{
    use HasFactory;
    use SoftDeletes;

    final public const DefaultChannel = 'mail';

    protected $table = 'deadman_channels';

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at',
        'type',
        'active',
        'key',
        'title',
        'description'
    ];

    protected $casts = [
        'type' => ChannelType::class
    ];

    public function switches(): BelongsToMany
    {
        return $this->belongsToMany(
            DMSwitch::class,
            'deadman_switch_channels',
            'channel_id',
            'switch_id'
        )
            ->withPivot(['id', 'channel_config', 'confirmation_sent', 'sort_order'])
            ->withCasts(['channel_config' => 'array'])
            ->using(SwitchChannels::class)
            ->orderBy('sort_order');
    }

    public function contacts(): BelongsToMany
    {
        return $this->belongsToMany(
            Contact::class,
            'deadman_contact_notification_targets',
            'contact_id',
            'channel_id',
        )
            ->withPivot(['id', 'active', 'subject', 'template', 'sort_order'])
            ->using(ContactNotificationTargets::class)
            ->orderBy('sort_order');
    }

    public function scopeActive(Builder $query): void
    {
        $query->where('active', 1);
    }

    protected static function newFactory(): Factory
    {
        return ChannelFactory::new();
    }
}
