<?php

namespace Netzperfekt\SaasDeadman\Models;

use Database\Factories\ContactRecipientFactory;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ContactRecipient extends Model
{
    use HasFactory;

    protected $table = 'deadman_contact_recipients';

    protected $fillable = [
        'id', 'created_at', 'updated_at',
        'contact_id',
        'channel_id',
        'recipients',
        'confirmations'
    ];

    protected $casts = [
        'recipients'    => 'array',
        'confirmations' => 'array'
    ];

    public function contact(): BelongsTo
    {
        return $this->belongsTo(Contact::class, 'id', 'contact_id');
    }

    protected static function newFactory(): Factory
    {
        return ContactRecipientFactory::new();
    }
}
