<?php

namespace Netzperfekt\SaasDeadman\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\Pivot;

class SwitchActions extends Pivot
{
    protected $table = 'deadman_switch_actions';
    public $incrementing = true;

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at',
        'switch_id',
        'action_id',

        'channel_id',
        'notification_contacts',
        'notification_sent'
    ];

    protected $casts = [
        'notification_contacts' => 'array'
    ];

    public function channel(): BelongsTo
    {
        return $this->belongsTo(Channel::class);
    }
}
