<?php

namespace Netzperfekt\SaasDeadman\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\HtmlString;
use Netzperfekt\SaasDeadman\Models\DMSwitch;

class AdminInfo extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(public readonly DMSwitch $switch)
    {
        $this->queue = config('saas-deadman.queue_confirmations');
    }

    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        $firstUser = $this->switch->team->members->first();

        return (new MailMessage)
            ->subject(__('deadman-mail-admininfo-subject', ['switch' => $this->switch->title]))
            ->greeting(new HtmlString(__('deadman-mail-admininfo-greeting', ['name' => $firstUser->name])))
            ->line(
                new HtmlString(
                    __('deadman-mail-admininfo-message', [
                        'switch' => $this->switch->title,
                        'user'   => $firstUser->name . ' / ' . $firstUser->email,
                        'date'   => $this->switch->updated_at->formatWithTimezone('d.m.Y H:i', $firstUser->timezone)
                    ]
                    )
                )
            )
            ->line(new HtmlString(__('deadman-mail-admininfo-outro')));
    }

    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
