<?php

namespace Netzperfekt\SaasDeadman\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\HtmlString;
use Netzperfekt\SaasDeadman\Models\Channel;
use Netzperfekt\SaasDeadman\Models\DMSwitch;

class TestNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(public readonly DMSwitch $switch,
                                public readonly Channel $channel)
    {
        $this->queue = config('saas-deadman.queue_confirmations');
    }

    public function via(object $notifiable): array
    {
        return [ $this->channel->type->getNotificationChannel() ];
    }

    public function toMail(object $notifiable): MailMessage
    {
        $firstUser = $this->switch->team->members->first();

        $testUrl = URL::signedRoute(
            'front.mail.test', [
                'channelId' => $this->channel->id,
                'switchId' => $this->switch->id
            ]
        );

        return (new MailMessage)
            ->greeting(new HtmlString(__('deadman-mail-test-greeting', ['name' => $firstUser->name])))
            ->line(new HtmlString(__('deadman-mail-test-intro', ['channel' => $this->channel->title])))
            ->action(new HtmlString(__('deadman-mail-test-action')), $testUrl)
            ->line(new HtmlString(__('deadman-mail-test-outro')));
    }

    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
