<?php

namespace Netzperfekt\SaasDeadman;

use Filament\Contracts\Plugin;
use Filament\Panel;
use Netzperfekt\SaasDeadman\Filament\OnBoarding\OnBoarding;
use Netzperfekt\SaasDeadman\Filament\Resources\ChannelResource\ChannelResource;
use Netzperfekt\SaasDeadman\Filament\Resources\ContactResource\ContactResource;
use Netzperfekt\SaasDeadman\Filament\Resources\ActionResource\ActionResource;
use Netzperfekt\SaasDeadman\Filament\Resources\SwitchResource\SwitchResource;

class SaasDeadman implements Plugin
{
    public final const PACKAGE_NAME = 'saas-deadman';

    protected bool $isEnabled = false;
    protected bool $forTenants = false;
    protected string $forTenantsPackage = '';

    public static function make(): SaasDeadman
    {
        return new SaasDeadman();
    }

    public function getId(): string
    {
        return self::PACKAGE_NAME;
    }

    public function register(Panel $panel): void
    {
        if($this->getIsEnabled())
        {
            $activeResources = [];
            $activePlugins = [];

            if($this->getForTenants())
            {
                $activeResources = [
                    ContactResource::class,
                    ActionResource::class,
                    SwitchResource::class
                ];

                $activePlugins = [
                    OnBoarding::getOnboarding()
                ];
            }
            else
            {
                $activeResources = [
                    ChannelResource::class,
                    ContactResource::class,
                    ActionResource::class,
                    SwitchResource::class
                ];
            }

            $panel->resources($activeResources);
            $panel->plugins($activePlugins);
        }
    }

    public function boot(Panel $panel): void
    {
        //
    }

    public function getIsEnabled(): bool
    {
        return $this->isEnabled;
    }

    public function isEnabled(bool $value): static
    {
        $this->isEnabled = $value;

        return $this;
    }

    public function getForTenants(): bool
    {
        return $this->forTenants;
    }

    public function getForTenantsPackage(): string
    {
        return $this->forTenantsPackage;
    }

    public function enableForTenantsInPackage(string $packageName): static
    {
        $this->forTenants = true;
        $this->forTenantsPackage = $packageName;

        return $this;
    }

    public static function get(): static
    {
        return filament(app(static::class)->getId());
    }
}
