<?php

namespace Netzperfekt\SaasDeadman\Services;

class CounterService
{
    protected $counter = [];

    public function resetCounter(?string $key = ''): void
    {
        if($key == '')
        {
            $this->counter = [];
        }
        else {
            $this->counter[$key] = 0;
        }
    }

    public function setCounter(string $key, int $count = 1): void
    {
        $this->counter[$key] = $count;
    }

    public function increaseCounter(string $key, int $count = 1): void
    {
        if( ! array_key_exists($key, $this->counter))
        {
            $this->counter[$key] = $count;
        }
        else
        {
            $this->counter[$key] += $count;
        }
    }

    public function getCounter(?string $key = ''): int|array
    {
        if($key == '')
        {
            return $this->counter;
        }

        return $this->counter[$key];
    }
}
