<?php

namespace Netzperfekt\SaasDeadman\States;

use Spatie\ModelStates\State;
use Spatie\ModelStates\StateConfig;

abstract class SwitchState extends State
{
    public static function config(): StateConfig
    {
        // TODO die custom transition classes noch hinzufügen
        return parent::config()
            ->default(SwitchIdle::class)

            ->allowTransition(SwitchIdle::class, SwitchMustConfirm::class, TransitionToMustConfirm::class)
            ->allowTransition(SwitchIdle::class, SwitchTriggered::class, TransitionToTriggered::class)
            ->allowTransition(SwitchIdle::class, SwitchIdle::class, TransitionToIdle::class)

            ->allowTransition(SwitchMustConfirm::class, SwitchTriggered::class, TransitionToTriggered::class)
            ->allowTransition(SwitchMustConfirm::class, SwitchGracePeriod::class, TransitionToGracePeriod::class)
            ->allowTransition(SwitchMustConfirm::class, SwitchIdle::class, TransitionToIdle::class)

            ->allowTransition(SwitchGracePeriod::class, SwitchTriggered::class, TransitionToTriggered::class)
            ->allowTransition(SwitchGracePeriod::class, SwitchIdle::class, TransitionToIdle::class)

            // ->allowTransition(SwitchGracePeriod::class, SwitchTriggered::class)
            // ->allowTransition(SwitchGracePeriod::class, SwitchIdle::class, TransitionToIdle::class)

            ->allowTransition(SwitchTriggered::class, SwitchIdle::class, TransitionToIdle::class);
    }
}
