<?php

namespace Netzperfekt\SaasDeadman\States;

use Netzperfekt\SaasDeadman\Models\DMSwitch;
use Spatie\ModelStates\Transition;

class TransitionToIdle extends Transition
{
    public function __construct(private readonly DMSwitch $switch)
    {
    }

    public function handle(): DMSwitch
    {
        $this->switch->last_confirmation = null;
        $this->switch->triggered_at = null;
        $this->switch->updateNextConfirmationDates();

        $this->switch->state = new SwitchIdle($this->switch);

        $this->switch->save();

        return $this->switch;
    }

    public function canTransition(): bool
    {
        return true;
    }
}
