<?php

namespace Netzperfekt\SaasDeadman\States;

use Netzperfekt\SaasDeadman\Facades\CounterService;
use Netzperfekt\SaasDeadman\Facades\SwitchService;
use Netzperfekt\SaasDeadman\Models\DMSwitch;
use Spatie\ModelStates\Transition;

class TransitionToMustConfirm extends Transition
{
    public function __construct(private readonly DMSwitch $switch)
    {
    }

    public function handle(): DMSwitch
    {
        $countNotifications = 0;

        foreach($this->switch->channels as $channel)
        {
            $countNotifications += SwitchService::sendConfirmationNotifications(
                $this->switch, $channel
            );
        }

        $this->switch->updateNextConfirmationDates(true);
        $this->switch->state = new SwitchMustConfirm($this->switch);
        $this->switch->save();

        CounterService::increaseCounter('mustconfirm_notifications', $countNotifications);

        return $this->switch;
    }

    public function canTransition(): bool
    {
        return $this->switch->isIdle() &&
               $this->switch->isOverdue(false);
    }
}
