<?php

namespace Netzperfekt\SaasDeadman\States;

use Carbon\Carbon;
use Illuminate\Support\Facades\Notification as LaravelNotification;
use Netzperfekt\SaasBase\Models\Settings;
use Netzperfekt\SaasBase\Models\User;
use Netzperfekt\SaasDeadman\Facades\CounterService;
use Netzperfekt\SaasDeadman\Facades\SwitchService;
use Netzperfekt\SaasDeadman\Models\DMSwitch;
use Netzperfekt\SaasDeadman\Notifications\AdminInfo;
use Spatie\ModelStates\Transition;

class TransitionToTriggered extends Transition
{
    public function __construct(private readonly DMSwitch $switch,
                                private readonly bool $force = false)
    {
    }

    public function handle(): DMSwitch
    {
        $countNotifications = 0;

        foreach($this->switch->actions as $notification)
        {
            // TODO hier noch zwischen notifications und anderen actions unterscheiden und entsprechend ausführen
            $countNotifications += SwitchService::sendTriggerNotifications(
                $this->switch, $notification
            );
        }

        $this->switch->triggered_at = Carbon::now();
        $this->switch->state = new SwitchTriggered($this->switch);
        $this->switch->save();

        if(Settings::get('settings-deadman-notify-admins', false))
        {
            $adminUser = User::superAdmin()->first();
            LaravelNotification::route('mail', $adminUser->email)->notifyNow(new AdminInfo($this->switch));
        }

        CounterService::increaseCounter('triggered_notifications', $countNotifications);

        return $this->switch;
    }

    public function canTransition(): bool
    {
        return ($this->force) ||
               (
                   ($this->switch->isMustConfirm() || $this->switch->isInGracePeriod()) &&
                    $this->switch->isOverdue()
               );
    }
}
