<?php

use Illuminate\Support\Facades\Auth;
use Netzperfekt\SaasBase\Models\Team;

const FORMAT_DISPLAY_DATETIME = 'd.m.Y / H:i';

if (! function_exists('loginAsTeam'))
{
    function loginAsTeam(int $teamId): bool
    {
        $team = Team::where('id', $teamId)->first();
        if(! $team)
        {
            return false;
        }

        $firstUserOfThisTeam = $team->members()->first();
        if(! $firstUserOfThisTeam)
        {
            return false;
        }
        $firstUserOfThisTeam->current_team_id = $teamId; // can be overwritten - is newly set at next login of this user
        $firstUserOfThisTeam->save();

        activity()->withoutLogs(fn () =>
            Auth::login($firstUserOfThisTeam)
        );

        return true;
    }
}
