<?php

use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasDeadman\Models\Channel;
use Netzperfekt\SaasDeadman\Models\Contact;
use Netzperfekt\SaasDeadman\Models\ContactRecipient;
use function Pest\Faker\fake;

describe('contact', function()
{
    it('can create contact properly and has the correct team', function ()
    {
        $team = Team::factory()->create();
        $contact = Contact::factory()->create(['team_id' => $team]);
        $channel = Channel::factory()->email()->create();

        ContactRecipient::factory()
            ->channel($channel)
            ->contact($contact)
            ->recipients([ fake()->safeEmail() ])
            ->create();

        $this->assertTrue($contact->team->is($team));

        $this->assertDatabaseHas(
            'deadman_contacts',
            Arr::except($contact->attributesToArray(), ['created_at', 'updated_at', 'last_confirmation', 'next_confirmation'])
        );

        $testContact = Contact::find($contact->id);
        $this->assertEquals($testContact->recipients, $contact->recipients);
    });

    it('can show the fullname', function ()
    {
        $contact = Contact::factory()->create();

        $fullName = $contact->lastname . ', ' . $contact->firstname;

        expect($fullName)->toBe($contact->fullname);
    });

    it('gets only contacts with type myself', function ()
    {
        $contacts = Contact::factory()
            ->count(1)
            ->create(['type' => \Netzperfekt\SaasDeadman\Enums\ContactType::Myself]);

        $contactsWithTypeMyself = Contact::ownContact()->get();

        expect($contactsWithTypeMyself)
            ->toHaveCount(1);

        expect($contactsWithTypeMyself)
            ->each()->toHaveKey('type', \Netzperfekt\SaasDeadman\Enums\ContactType::Myself->value);

        expect($contactsWithTypeMyself)
            ->each(fn($item) => expect($item->value->isOwnContact())->toBeTrue());
    });

    it('gets only contacts without type myself', function ()
    {
        $contactMyself = Contact::factory()
            ->create(['type' => \Netzperfekt\SaasDeadman\Enums\ContactType::Myself]);

        $contactPartner = Contact::factory()
            ->create(['type' => \Netzperfekt\SaasDeadman\Enums\ContactType::PrivatePartner]);

        $contactFinance = Contact::factory()
            ->create(['type' => \Netzperfekt\SaasDeadman\Enums\ContactType::Finance]);

        $contactsWithoutTypeMyself = Contact::withoutMyself()->get();

        expect($contactsWithoutTypeMyself)
            ->toHaveCount(2);

        expect($contactsWithoutTypeMyself)
            ->each(fn($item) => expect($item->value->type)->not()->toBe(\Netzperfekt\SaasDeadman\Enums\ContactType::Myself));

    });

    // TODO public function switches(): BelongsToMany

    // TODO public function switchConfirmers(): BelongsToMany

    // TODO public function notificationTargets(): BelongsToMany

})->group('unit');
