<?php

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Sequence;

describe('switch confirmation', function()
{
    it('tests if a switch without additional confirmers is completely confirmed', function ()
    {
        $team = \Netzperfekt\SaasBase\Models\Team::factory()->create();
        $switch = \Netzperfekt\SaasDeadman\Models\DMSwitch::factory()
            ->confirmedByOwner()
            ->create(['team_id' => $team]);

        expect($switch->confirmations)->toHaveKey('_0');
    });

    it('tests if a switch with two additional confirmers (at least 2 must confirm) and no confirmation from owner is completely confirmed', function ()
    {
        $team = \Netzperfekt\SaasBase\Models\Team::factory()->create();
        $contact1 = \Netzperfekt\SaasDeadman\Models\Contact::factory()->create(['team_id' => $team]);
        $contact2 = \Netzperfekt\SaasDeadman\Models\Contact::factory()->create(['team_id' => $team]);
        $contact3 = \Netzperfekt\SaasDeadman\Models\Contact::factory()->create(['team_id' => $team]);

        $switch = \Netzperfekt\SaasDeadman\Models\DMSwitch::factory()
            ->confirmedBy([$contact1, $contact2])
            ->hasAttached([$contact1, $contact2, $contact3], relationship: 'confirmers')
            ->create(['team_id' => $team, 'confirmation_mode' => 2]);

        $isCompletelyConfirmed = $switch->isCompletelyConfirmed();

        expect($isCompletelyConfirmed)->toBeTrue();
    });

    it('tests if a switch with two additional confirmers (but 3 must confirm) and no confirmation from owner is NOT completely confirmed', function ()
    {
        $team = \Netzperfekt\SaasBase\Models\Team::factory()->create();
        $contact1 = \Netzperfekt\SaasDeadman\Models\Contact::factory()->create(['team_id' => $team]);
        $contact2 = \Netzperfekt\SaasDeadman\Models\Contact::factory()->create(['team_id' => $team]);
        $contact3 = \Netzperfekt\SaasDeadman\Models\Contact::factory()->create(['team_id' => $team]);

        $switch = \Netzperfekt\SaasDeadman\Models\DMSwitch::factory()
            ->confirmedBy([$contact1, $contact2])
            ->hasAttached([$contact1, $contact2, $contact3], relationship: 'confirmers')
            ->create(['team_id' => $team, 'confirmation_mode' => 3]);

        $isCompletelyConfirmed = $switch->isCompletelyConfirmed();

        expect($isCompletelyConfirmed)->toBeFalse();
    });

    it('tests if a switch with two additional confirmers (at least 3 must confirm) and confirmation from owner is completely confirmed', function ()
    {
        $team = \Netzperfekt\SaasBase\Models\Team::factory()->create();
        $contact1 = \Netzperfekt\SaasDeadman\Models\Contact::factory()->create(['team_id' => $team]);
        $contact2 = \Netzperfekt\SaasDeadman\Models\Contact::factory()->create(['team_id' => $team]);
        $contact3 = \Netzperfekt\SaasDeadman\Models\Contact::factory()->create(['team_id' => $team]);

        $switch = \Netzperfekt\SaasDeadman\Models\DMSwitch::factory()
            ->confirmedByOwner()
            ->confirmedBy([$contact1, $contact2])
            ->hasAttached([$contact1, $contact2, $contact3], relationship: 'confirmers')
            ->create(['team_id' => $team, 'confirmation_mode' => 3]);

        $isCompletelyConfirmed = $switch->isCompletelyConfirmed();

        expect($isCompletelyConfirmed)->toBeTrue();
    });

    it('tests if a switch with no additional confirmers (but 2 must confirm) and no confirmation from owner is NOT completely confirmed', function ()
    {
        $team = \Netzperfekt\SaasBase\Models\Team::factory()->create();
        $contact1 = \Netzperfekt\SaasDeadman\Models\Contact::factory()->create(['team_id' => $team]);
        $contact2 = \Netzperfekt\SaasDeadman\Models\Contact::factory()->create(['team_id' => $team]);
        $contact3 = \Netzperfekt\SaasDeadman\Models\Contact::factory()->create(['team_id' => $team]);

        $switch = \Netzperfekt\SaasDeadman\Models\DMSwitch::factory()
            ->confirmedBy([])
            ->hasAttached([$contact1, $contact2, $contact3], relationship: 'confirmers')
            ->create(['team_id' => $team, 'confirmation_mode' => 3]);

        $isCompletelyConfirmed = $switch->isCompletelyConfirmed();

        expect($isCompletelyConfirmed)->toBeFalse();
    });
})->group('unit');