<?php

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Sequence;
use Netzperfekt\SaasDeadman\Enums\SwitchStateEnum;

describe('switch', function()
{
    it('can create switch properly and has the correct team', function ()
    {
        $team = \Netzperfekt\SaasBase\Models\Team::factory()->create();
        $switch = \Netzperfekt\SaasDeadman\Models\DMSwitch::factory()->stateIdle()->create(['team_id' => $team]);

        expect($switch->state->equals(\Netzperfekt\SaasDeadman\States\SwitchIdle::class))->toBeTrue();

        $this->assertDatabaseHas(
            'deadman_switches',
            Arr::except($switch->attributesToArray(), [
                'created_at', 'updated_at', 'pause_from', 'pause_until',
                'last_confirmation', 'next_confirmation', 'next_confirmation_with_grace', 'confirmations'
            ])
        );
        $this->assertTrue($switch->team->is($team));
    });

    it('gets only active switches', function ()
    {
        $contacts = \Netzperfekt\SaasDeadman\Models\DMSwitch::factory()
            ->count(10)
            ->state(new Sequence(
                ['active' => false],
                ['active' => true],
            ))
            ->create();

        $contactsActive = \Netzperfekt\SaasDeadman\Models\DMSwitch::active()->get();

        expect($contactsActive)->toHaveCount(5);
    });

    it('gets only idle switches', function ()
    {
        $contacts = \Netzperfekt\SaasDeadman\Models\DMSwitch::factory()
            ->count(10)
            ->state(new Sequence(
                ['state' => \Netzperfekt\SaasDeadman\States\SwitchIdle::class],
                ['state' => \Netzperfekt\SaasDeadman\States\SwitchMustConfirm::class],
            ))
            ->create();

        $contactsIdle = \Netzperfekt\SaasDeadman\Models\DMSwitch::idle()->get();

        expect($contactsIdle)->toHaveCount(5);
    });

    it('gets only not paused switches', function ()
    {
        $contacts = \Netzperfekt\SaasDeadman\Models\DMSwitch::factory()
            ->count(10)
            ->state(new Sequence(
                ['pause_from' => Carbon::now()->subtract('1day'), 'pause_until' => Carbon::now()->add('1day')],
                ['pause_from' => Carbon::now()->add('1day'), 'pause_until' => Carbon::now()->add('2days')],
            ))
            ->create();

        $contactsNotPaused = \Netzperfekt\SaasDeadman\Models\DMSwitch::notPaused()->get();

        expect($contactsNotPaused)->toHaveCount(5);
    });

    it('gets only switches to be confirmed', function ()
    {
        $contacts = \Netzperfekt\SaasDeadman\Models\DMSwitch::factory()
            ->count(10)
            ->state(new Sequence(
                ['state' => \Netzperfekt\SaasDeadman\States\SwitchIdle::class],
                ['state' => \Netzperfekt\SaasDeadman\States\SwitchMustConfirm::class],
            ))
            ->create();

        $contactsMustConfirm = \Netzperfekt\SaasDeadman\Models\DMSwitch::mustConfirm()->get();

        expect($contactsMustConfirm)->toHaveCount(5);
    });

    it('gets only triggered switches', function ()
    {
        $contacts = \Netzperfekt\SaasDeadman\Models\DMSwitch::factory()
            ->count(10)
            ->state(new Sequence(
                ['state' => \Netzperfekt\SaasDeadman\States\SwitchIdle::class],
                ['state' => \Netzperfekt\SaasDeadman\States\SwitchTriggered::class],
            ))
            ->create();

        $contactsTriggered = \Netzperfekt\SaasDeadman\Models\DMSwitch::triggered()->get();

        expect($contactsTriggered)->toHaveCount(5);
    });

    // TODO contacts

    // TODO channels

    // TODO confirmers

})->group('unit');