<?php

namespace Netzperfekt\SaasFaq\Controllers;

use Illuminate\Http\Request;
use Illuminate\View\View;
use Netzperfekt\SaasFaq\Models\FaqGroup;
use Netzperfekt\SaasFaq\SaasFaq;
use RalphJSmit\Filament\MediaLibrary\Media\Models\MediaLibraryItem;

class FaqController extends Controller
{
    public function showFaq(Request $request, string $slug): View
    {
        $faqGroup = FaqGroup
            ::withSlug($slug)
            ->with('activeFaq')
            ->first();

        if(! $faqGroup) {
            abort(404);
        }

        $mainImageMedia = MediaLibraryItem::find($faqGroup->image_id);

        $data = [
            'faqGroup' => $faqGroup,
            'mainimage' => $mainImageMedia,
            'template' => (object)$faqGroup->template,
        ];

        return view(SaasFaq::PACKAGE_NAME . '::faq', $data);
    }
}
