<?php

namespace Netzperfekt\SaasFaq\Data;

use Livewire\Wireable;
use Netzperfekt\SaasFaq\Models\Faq;
use Spatie\LaravelData\Concerns\WireableData;
use Spatie\LaravelData\Data;

class FaqData extends Data implements Wireable
{
    use WireableData;

    public function __construct
    (
        public ?string $slug = '',
        public ?string $title = '',
        public ?faq $faq = null,

        public array $colors = [], // TODO

        public array $menuHeader = [],
        public array $menuFooter = [],
    ) {}
}
