<?php

namespace Netzperfekt\SaasFaq;

use Netzperfekt\SaasBase\Events\GetSettingsFieldsEvent;
use Netzperfekt\SaasBase\Events\GetSitemapEvent;
use Netzperfekt\SaasFaq\Listeners\GetCmsLinkTypes;
use Netzperfekt\SaasFaq\Listeners\GetFaqGroups;
use Netzperfekt\SaasFaq\Listeners\GetSettingsFields;
use Netzperfekt\SaasFaq\Listeners\GetSitemapListener;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        GetSitemapEvent::class => [
            GetSitemapListener::class
        ],
        GetSettingsFieldsEvent::class => [
            GetSettingsFields::class
        ],
        'Netzperfekt\SaasCms\Events\GetCmsLinkTypesEvent' => [
            GetCmsLinkTypes::class
        ],
        'Netzperfekt\SaasCms\Events\GetFaqGroupsEvent' => [
            GetFaqGroups::class
        ],
    ];

    public function boot(): void
    {
        //
    }

    public function shouldDiscoverEvents(): bool
    {
        return false;
    }
}
