<?php

namespace Netzperfekt\SaasFaq\Filament\Exporter;

use Filament\Actions\Exports\Enums\ExportFormat;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;
use Netzperfekt\SaasFaq\Models\Faq;

class FaqExporter extends Exporter
{
    protected static ?string $model = Faq::class;

    public function getJobConnection(): ?string
    {
        return 'sync';
    }

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('is_active'),
            ExportColumn::make('title'),
            ExportColumn::make('slug'),
            ExportColumn::make('module'),
            ExportColumn::make('image_id'),
            ExportColumn::make('description'),
            ExportColumn::make('contents')->listAsJson()
        ];
    }

    public function getFormats(): array
    {
        return [
            ExportFormat::Csv,
        ];
    }

    public function getFileName(Export $export): string
    {
        return "faq-{$export->getKey()}";
    }

    public static function getCompletedNotificationTitle(Export $export): string
    {
        return 'Export FAQ';
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $body = 'Der Export wurde abgeschlossen, es wurden ' . number_format($export->successful_rows) . ' Einträge exportiert.';

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $body .= ' ' . number_format($failedRowsCount) . ' Einträge konnten nicht exportiert werden.';
        }

        return $body;
    }
}
