<?php

namespace Netzperfekt\SaasFaq\Filament\Exporter;

use Filament\Actions\Imports\ImportColumn;
use Filament\Actions\Imports\Importer;
use Filament\Actions\Imports\Models\Import;
use Netzperfekt\SaasFaq\Models\Faq;

class FaqImporter extends Importer
{
    protected static ?string $model = Faq::class;

    public function getJobConnection(): ?string
    {
        return 'sync';
    }

    public static function getColumns(): array
    {
        return [
            ImportColumn::make('is_active')
                ->validationAttribute('is_active'),

            ImportColumn::make('title')
                ->validationAttribute('title'),

            ImportColumn::make('slug')
                ->validationAttribute('slug'),

            ImportColumn::make('module')
                ->validationAttribute('module'),

            ImportColumn::make('image_id')
                ->validationAttribute('image_id'),

            ImportColumn::make('description')
                ->validationAttribute('description'),

            ImportColumn::make('contents')
                ->validationAttribute('contents')
                ->castStateUsing(function (?string $state): ?array
                {
                    return json_decode($state, true);
                }),
        ];
    }

    public function resolveRecord(): ?Faq
    {
        return Faq::firstOrNew([
            'slug' => $this->data['slug'],
        ]);
    }

    public static function getCompletedNotificationTitle(Import $import): string
    {
        return 'Import FAQ';
    }

    public static function getCompletedNotificationBody(Import $import): string
    {
        $body = 'Der Import wurde ausgeführt und ' . number_format($import->successful_rows) . ' Einträge wurden importiert.';

        if ($failedRowsCount = $import->getFailedRowsCount()) {
            $body .= ' ' . number_format($failedRowsCount) . ' Einträge konnten nicht importiert werden.';
        }

        return $body;
    }
}
