<?php

namespace Netzperfekt\SaasFaq\Filament\Exporter;

use Illuminate\Support\Str;
use League\Csv\CharsetConverter;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;

class ImportAction extends \Filament\Tables\Actions\ImportAction
{
    public function getUploadedFileStream(TemporaryUploadedFile $file)
    {
        // copied from CanImportRecords.php
        $filePath = $file->getRealPath();

        // removed s3 handling - needs to be uploaded to local disk
        $resource = fopen($filePath, mode: 'r');

        $inputEncoding = $this->detectCsvEncoding($resource);
        $outputEncoding = 'UTF-8';

        if (
            filled($inputEncoding) &&
            (Str::lower($inputEncoding) !== Str::lower($outputEncoding))
        ) {
            CharsetConverter::register();

            stream_filter_append(
                $resource,
                CharsetConverter::getFiltername($inputEncoding, $outputEncoding),
                STREAM_FILTER_READ,
            );
        }

        return $resource;
    }
}
