<?php

namespace Netzperfekt\SaasFaq\Filament\Resources\FaqGroupResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Filament\Support\Enums\ActionSize;
use Netzperfekt\SaasBase\Traits\HasEditPageActions;
use Netzperfekt\SaasFaq\Filament\Resources\FaqGroupResource\FaqGroupResource;

class EditFaqGroup extends EditRecord
{
    use HasEditPageActions;

    protected static string $resource = FaqGroupResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('preview')
                ->label(__('cms-preview'))
                ->icon('fas-bolt')
                ->size(ActionSize::Medium)
                ->color('info')
                ->url(fn($record) => route('faq.group', $record->slug))
                ->openUrlInNewTab(),

            Actions\DeleteAction::make(),
        ];
    }
}
