<?php

namespace Netzperfekt\SaasFaq\Filament\Resources\FaqGroupResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Components\Select;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Support\Enums\IconSize;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Netzperfekt\SaasFaq\Filament\Resources\FaqResource\FaqResource;

class FaqRelationManager extends RelationManager
{
    protected static string $relationship = 'faq';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('title')
                    ->required()
                    ->maxLength(255),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('title')
            ->columns([
                Tables\Columns\TextColumn::make('title')
                    ->label(__('faq-title')),

                Tables\Columns\TextColumn::make('module')
                    ->label(__('faq-module'))
                    ->badge(),
            ])

            ->filters([
                //
            ])

            ->headerActions([
                Tables\Actions\AttachAction::make()
                    ->preloadRecordSelect()
                    ->recordSelect(
                        fn (Select $select) => $select->placeholder('FAQ auswählen')->multiple(),
                    )
                    ->recordSelectOptionsQuery(fn(Builder $query) => $query->onlyMyRecords())
            ])

            ->actions([
                Tables\Actions\EditAction::make()
                    ->label('')
                    ->tooltip('Bearbeiten')
                    ->iconSize(IconSize::Medium)
                    ->url(fn (Model $record): string => FaqResource::getUrl('edit', ['record' => $record])),

                Tables\Actions\DetachAction::make()
                    ->label('')
                    ->tooltip('Trennen')
                    ->iconSize(IconSize::Medium)
            ])

            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DetachBulkAction::make()
                ]),
            ])

            ->defaultSort('sort_order', 'asc')
            ->reorderable('sort_order', true)
            ->reorderRecordsTriggerAction(
                fn (Tables\Actions\Action $action, bool $isReordering) => $action
                    ->button()
                    ->label($isReordering ? __('faq-sort-save') : __('faq-sort'))
                    ->color($isReordering ? 'warning' : 'gray')
            );
    }
}
