<?php

namespace Netzperfekt\SaasFaq\Filament\Resources\FaqResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Filament\Support\Enums\ActionSize;
use Netzperfekt\SaasBase\Traits\HasEditPageActions;
use Netzperfekt\SaasFaq\Filament\Resources\FaqResource\FaqResource;

class EditFaqPage extends EditRecord
{
    use HasEditPageActions;

    protected static string $resource = FaqResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('preview')
                ->label('Vorschau')
                ->icon('fas-bolt')
                ->size(ActionSize::Medium)
                ->color('info')
                // TODO preview ->url(fn($record) => route('faq', $record->slug))
                ->openUrlInNewTab()
                ->visible(fn($record) => $record->slug),

            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }
}
