<?php

namespace Netzperfekt\SaasFaq\Listeners;

use Netzperfekt\SaasFaq\Models\FaqGroup;
use Netzperfekt\SaasCms\Enums\CmsLinkType;

class GetCmsLinkTypes
{
    public function handle($event): array
    {
        if($event->getReturnType() == CmsLinkType::Route)
        {
            return [
                'model' => FaqGroup::class,
                'route' => 'faq.group'
            ];
        }

        return [
            'type'      => __('faq-link-type'),
            'label'     => __('faq-link-label'),
            'model'     => FaqGroup::class,
            'modelid'   => 'id',
            'modelname' => 'title',
        ];
    }
}

