<?php

namespace Netzperfekt\SaasFaq\Listeners;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;

class GetSettingsFields
{
    public function handle($event): array
    {
        return [
            'label'  => __('settings-faq'),
            'fields' => [
                TextInput::make('settings-faq-url-pattern')
                    ->label('URL-Pattern für FAQ-Seiten')
                    ->required()
                    ->default(config('saas-faq.default-url-pattern')),

                Toggle::make('settings-faq-likecounter')
                    ->label(__('faq-settings-likecounter'))
                    ->hint(__('faq-settings-likecounter-hint')),

                Toggle::make('settings-faq-supportform')
                    ->label(__('faq-settings-support-form'))
                    ->hint(__('faq-settings-support-form-hint'))
            ]
        ];
    }
}
