<?php

namespace Netzperfekt\SaasFaq\Livewire;

use Livewire\Component;
use Netzperfekt\SaasBase\Models\Settings;
use Netzperfekt\SaasFaq\Models\Faq;
use Netzperfekt\SaasFaq\SaasFaq;

class LikeCounter extends Component
{
    public int $faqId = 0;
    public array $faqData = [];
    public int $likeCount = 0;

    public function mount(int|string $faqId, array $faqData)
    {
        $this->faqId = (int)$faqId;
        $this->faqData = $faqData;
        $this->likeCount = array_key_exists('counter', $faqData) ? (int)$faqData['counter'] : 0;
    }

    public function render()
    {
        $showLikeCounter = Settings::get('settings-faq-likecounter', false);
        if(! $showLikeCounter)
        {
            return view(SaasFaq::PACKAGE_NAME . '::livewire.like-counter-disabled');
        }

        return view(SaasFaq::PACKAGE_NAME . '::livewire.like-counter')
            ->extends(SaasFaq::PACKAGE_NAME . '::frontend.layout')
            ->section('content');
    }

    public function increment()
    {
        $this->likeCount++;

        Faq::setCounter($this->faqId, $this->faqData['id'], $this->likeCount);
    }
}
