<?php

namespace Netzperfekt\SaasFaq\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasBase\Traits\HasDefaultScopes;
use Netzperfekt\SaasBase\Traits\HasGlobalModelObserver;
use Netzperfekt\SaasFaq\Data\FaqData;
use RalphJSmit\Filament\MediaLibrary\Media\Models\MediaLibraryItem;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Faq extends Model implements HasMedia
{
    use InteractsWithMedia, SoftDeletes;
    use HasGlobalModelObserver;
    use HasDefaultScopes;

    protected $table = 'faq';

    protected $fillable = [
        'team_id',
        'is_active',
        'title',
        'slug',
        'module',
        'description',
        'contents',
        'image_id'
    ];

    protected $casts = [
        'contents'  => 'array',
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function faqGroups(): BelongsToMany
    {
        return $this->belongsToMany(FaqGroup::class, 'faq_groups_faq')->withPivot('sort_order');
    }

    public function thumbnail(): BelongsTo
    {
        return $this->belongsTo(MediaLibraryItem::class, 'image_id');
    }

    public function scopeActive(Builder $query): void
    {
        $query->where('is_active', true);
    }

    public function scopeWithSlug(Builder $query, string $slug): void
    {
        $query->where('slug', $slug);
    }

    public static function setCounter(int $faqId, string $itemId, int $newCounter)
    {
        $faq = Faq::find($faqId);
        $contents = $faq->contents;

        $faq->contents = updateValueInArray($contents, 'id', $itemId, 'counter', $newCounter);

        $faq->update();
    }

    /* TODO raus? */
    public static function getFaq(string $slug,
                                   string $module): FaqData
    {
        $faq = self::class::active()->where('slug', $slug)->where('module', $module)->first();

        return FaqData::from([
            'slug'  => $slug,
            'title' => $faq->title,
            'faq'   => $faq,

            // TODO colors in faq page!
            'colors'     => [
                'colorBackground' => '#ffffff',
                'colorText'       => '#000000',
                'colorHighlight'  => '#0000ff'
            ]
        ]);
    }
}
