<?php

namespace Netzperfekt\SaasFaq\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasBase\Traits\HasDefaultScopes;
use Netzperfekt\SaasBase\Traits\HasGlobalModelObserver;
use Netzperfekt\SaasCms\Models\CmsTemplate;
use Netzperfekt\SaasFaq\Data\FaqData;
use Netzperfekt\SaasFaq\Data\FaqGroupData;
use RalphJSmit\Filament\MediaLibrary\Media\Models\MediaLibraryItem;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class FaqGroup extends Model implements HasMedia
{
    use InteractsWithMedia, SoftDeletes;
    use HasGlobalModelObserver;
    use HasDefaultScopes;

    protected $table = 'faq_groups';

    protected $fillable = [
        'team_id',
        'title',
        'slug',
        'module',
        'description',
        'image_id',
        'template_id',
        'seo_title',
        'seo_description'
    ];

    protected $casts = [
        'image_ids' => 'array'
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function faq(): BelongsToMany
    {
        return $this->belongsToMany(Faq::class, 'faq_groups_faq')->withPivot('sort_order');
    }

    public function activeFaq(): BelongsToMany
    {
        return $this->belongsToMany(Faq::class, 'faq_groups_faq')
            ->withPivot('sort_order')
            ->where('is_active', true);
    }

    public function thumbnail(): BelongsTo
    {
        return $this->belongsTo(MediaLibraryItem::class, 'image_id');
    }

    public function template(): BelongsTo
    {
        return $this->belongsTo(CmsTemplate::class);
    }

    public function scopeWithSlug(Builder $query, string $slug): void
    {
        $query->where('slug', $slug);
    }

    /* TODO raus? */
    public static function getGroup(string $slug): ?FaqGroupData
    {
        $faqGroup = self::class::where('slug', $slug)->first();
        if( ! $faqGroup) {
            return null;
        }

        $faqItems = $faqGroup->faq->map(function($faq)
        {
            return FaqData::from([
                'slug'  => $faq->slug,
                'title' => $faq->title,
                'faq'   => $faq,

                // TODO colors in faq page!
                'colors'     => [
                    'colorBackground' => '#ffffff',
                    'colorText'       => '#000000',
                    'colorHighlight'  => '#0000ff'
                ]
            ]);
        });

        return FaqGroupData::from([
            'slug'        => $slug,
            'title'       => $faqGroup->title,
            'description' => $faqGroup->description,

            // TODO colors from where?
            'colors'     => [
                'colorBackground' => '#ffffff',
                'colorText'       => '#000000',
                'colorHighlight'  => '#0000ff'
            ],

            'faq'         => $faqItems
        ]);
    }
}
