<?php

namespace Netzperfekt\SaasFaq;

use Filament\Contracts\Plugin;
use Filament\Panel;
use Netzperfekt\SaasFaq\Filament\Resources\FaqGroupResource\FaqGroupResource;
use Netzperfekt\SaasFaq\Filament\Resources\FaqResource\FaqResource;

class SaasFaq implements Plugin
{
    public final const PACKAGE_NAME = 'saas-faq';

    protected bool $isEnabled = false;
    protected bool $forTenants = false;
    protected string $forTenantsPackage = '';
    protected string $faqRoutePattern = '/faq/{slug}';

    public static function make(): SaasFaq
    {
        return new SaasFaq();
    }

    public function getId(): string
    {
        return self::PACKAGE_NAME;
    }

    public function register(Panel $panel): void
    {
        if($this->getIsEnabled())
        {
            $activeResources = [];

            // TODO macht hier wenig sinn, wenn ohnehin das gleiche für admin und app verwendet wird?!
            if($this->getForTenants())
            {
                $activeResources = [
                    FaqGroupResource::class,
                    FaqResource::class
                ];
            }
            else
            {
                $activeResources = [
                    FaqGroupResource::class,
                    FaqResource::class,
                ];
            }

            $panel->resources($activeResources);
        }
    }

    public function boot(Panel $panel): void
    {
        //
    }

    public function getFaqRoute(): string
    {
        return $this->faqRoutePattern;
    }

    public function faqRoute(string $route): static
    {
        $this->faqRoutePattern = $route;

        return $this;
    }

    public function getIsEnabled(): bool
    {
        return $this->isEnabled;
    }

    public function isEnabled(bool $value): static
    {
        $this->isEnabled = $value;

        return $this;
    }

    public function getForTenants(): bool
    {
        return $this->forTenants;
    }

    public function getForTenantsPackage(): string
    {
        return $this->forTenantsPackage;
    }

    public function enableForTenantsInPackage(string $packageName): static
    {
        $this->forTenants = true;
        $this->forTenantsPackage = $packageName;

        return $this;
    }

    public static function get(): static
    {
        return filament(app(static::class)->getId());
    }
}
