<?php

namespace Netzperfekt\SaasFaq;

use Filament\Support\Assets\Css;
use Filament\Support\Assets\Js;
use Filament\Support\Facades\FilamentAsset;
use Illuminate\Support\Facades\Blade;
use Livewire\Livewire;
use Spatie\LaravelPackageTools\Commands\InstallCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class SaasFaqServiceProvider extends PackageServiceProvider
{
    public function packageRegistered()
    {
        $this->app->register(EventServiceProvider::class);
    }

    public function packageBooted()
    {
        $this->addAssets();
        $this->registerComponents();
    }

    public function configurePackage(Package $package): void
    {
        $package
            ->name(SaasFaq::PACKAGE_NAME)
            ->hasRoute('web')
            ->hasViews()
            ->hasConfigFile()
            ->hasTranslations()

            ->hasMigrations([
                'create_faq_table',
                'create_faq_groups_table',
                'create_faq_groups_faq_table'
            ])

            ->hasInstallCommand(function(InstallCommand $command)
            {
                $command
                    ->publishAssets()
                    ->publishMigrations()
                    ->askToRunMigrations();
            });
    }

    private function addAssets()
    {
        FilamentAsset::register([
            Js::make('saas-faq-js', __DIR__ . '/../resources/dist/saas-faq.js'),
            Css::make('saas-faq-css', __DIR__ . '/../resources/dist/saas-faq.css')
        ], 'netzperfekt/saas-faq');

    }

    private function registerComponents()
    {
        Livewire::discover('Netzperfekt\\SaasFaq\\Livewire', 'saas-faq');

        Blade::componentNamespace('Netzperfekt\\SaasFaq\\View\\Components', 'faq');
    }
}
