<?php

namespace Netzperfekt\SaasFaq\View\Components;

use Illuminate\View\Component;
use Netzperfekt\SaasCms\Models\CmsTemplate;
use Netzperfekt\SaasFaq\Models\FaqGroup;

class Faq extends Component
{
    public $faqGroup = null;
    public $faqTemplate = null;

    public function __construct(public readonly int $group, public readonly int $template)
    {
        $this->faqGroup = FaqGroup::where('id', $this->group)->first();
        $this->faqTemplate = CmsTemplate::where('id', $this->template)->first();
    }

    public function render()
    {
        return view('saas-faq::frontend.components.faq', [
            'faqGroup' => $this->faqGroup,
            'faqTemplate' => $this->faqTemplate
        ]);
    }
}