<?php

use Illuminate\Support\Arr;
use Netzperfekt\SaasFaq\Data\FaqModuleDefinition;
use Netzperfekt\SaasFaq\Events\GetFaqModulesEvent;

if (! function_exists('getFaqModules'))
{
    function getFaqModules(): FaqModuleDefinition
    {
        $modules = config('saas-faq.default-faq-modules', []);
        $tmpModules = [];

        $callbackResults = array_filter(event(new GetFaqModulesEvent()));
        $tenantModules = [];

        foreach($callbackResults as $result)
        {
            $additionalModules = $result->modules;
            $tenantModules = array_merge($tenantModules, $result->tenantModules);

            foreach($additionalModules as $groupKey => $groupLabel)
            {
                $tmpModules[$groupKey] = $groupLabel;
            }
        }

        return FaqModuleDefinition::from([
            'modules'       => array_merge($modules, $tmpModules),
            'tenantModules' => $tenantModules
        ]);
    }
}

if (! function_exists('updateValueInArray'))
{
    function updateValueInArray(array $array, string $keyToFind, string $valueToFind, string $updateField, int $newValue)
    {
        $allEntries = Arr::dot($array);
        $results = array_filter($allEntries, function ($value, $key) use ($keyToFind, $valueToFind)
        {
            return str_ends_with($key, '.' . $keyToFind) && $value === $valueToFind;
        }, ARRAY_FILTER_USE_BOTH);

        if (count($results) > 0)
        {
            $keyToUpdate = trim(array_key_first($results), '.' . $keyToFind) . '.' . $updateField;
            data_set($array, $keyToUpdate, $newValue);
        }

        return $array;
    }
}