@php use Netzperfekt\SaasProptrend\Enums\FieldType; @endphp
<x-filament::page>
    <script>
        // DOM Element Picker - https://github.com/hmarr/pick-dom-element

        let picker = null;
        let isPicking = false;
        let infobox = null;

        addEventListener("DOMContentLoaded", (event) =>
        {
            picker = new window.ElementPicker({ borderColor: '#ff0000', background: 'rgba(255, 0, 0, 0.2)'});
        });

        function sanitizeValue(value, fieldType)
        {
            if(fieldType == {{ FieldType::Number->value }} ||
               fieldType == {{ FieldType::Price->value }} ||
               fieldType == {{ FieldType::Provision->value }} ||
               fieldType == {{ FieldType::QmHouse->value }})
            {
                value = value.replace(/\D/g,''); // remove all non-numeric chars
            }

            return value.trim(); // TEXT/other
        }

        function stopPicker()
        {
            picker.stop();

            infobox.remove();
            document.removeEventListener('keydown', stopPicker);
            isPicking = false;
        }

        function pickValue(domElement, fieldId, fieldLabel, fieldType)
        {
            const fieldEl = document.getElementById('field-value-' + fieldId);
            const fieldInputEl = fieldEl.querySelector('input');

            const fieldPathEl = document.getElementById('field-path-' + fieldId);
            const fieldPathInputEl = fieldPathEl.querySelector('input');

            if(isPicking)
            {
                stopPicker();
            }
            else
            {
                picker.start({
                    elementFilter: (el) =>
                    {
                        return el.closest(domElement);
                    },

                    onHover: (el) =>
                    {
                        // TODO show in overlay, show if there is a CLASS or ID
                        let fieldContent = el.textContent || el.innerText || '';
                        infobox.innerHTML = '<span class="label">' + fieldLabel + ':</span>' + sanitizeValue(fieldContent, fieldType);
                    },

                    onClick: (el) =>
                    {
                        // TODO manche portale (z.b. immowelt) vergeben RANDOM classes/ids immer wieder neu
                        //  -> macht dann keinen sinn, die wegzuspeichern. wie kann ich trotzdem die felder erkennen?!?

                        picker.stop();

                        let fieldContent = el.textContent || el.innerText || '';
                        fieldInputEl.value = sanitizeValue(fieldContent, fieldType);
                        fieldInputEl.dispatchEvent(new Event('input'));

                        if(el.id != '')
                        {
                            fieldPathInputEl.value = '#' + el.id;
                        }
                        else if(el.classList != '')
                        {
                            fieldPathInputEl.value = '.' + el.classList;
                        }

                        fieldPathInputEl.dispatchEvent(new Event('input'));

                        stopPicker();
                    }
                });

                infobox = document.createElement('div');
                infobox.setAttribute('id', 'infobox');
                infobox.textContent = '-';
                document.body.appendChild(infobox);

                document.addEventListener('keydown', (event) =>
                {
                    if(event.code == 'Escape')
                    {
                        stopPicker();
                    }
                }, false);

                isPicking = true;
            }
        }
    </script>

    <form wire:submit.prevent="submit">

        {{ $this->form }}

        <div class="mt-4">
            <x-filament-panels::form.actions
                    :actions="$this->getFormActions()" />
        </div>
    </form>
</x-filament::page>
