<?php

namespace Netzperfekt\SaasProptrend\Commands;

use Illuminate\Console\Command;
use Netzperfekt\SaasProptrend\Enums\PropStatus;
use Netzperfekt\SaasProptrend\Jobs\ProcessPropertyUpdate;
use Netzperfekt\SaasProptrend\Models\ProptrendProp;

class UpdatePropertiesCommand extends Command
{
    protected $signature = 'proptrend:update';

    protected $description = 'Updates properties';

    public function handle()
    {
        $this->updateProperties();
    }

    private function updateProperties()
    {
        $updateFrequencyDays = (int)setting('update_frequency');

        $allProperties = ProptrendProp
            ::where('status', '=', PropStatus::Active)
            ->whereDate('updated_at', '<=', now()->subDays($updateFrequencyDays)->setTime(0, 0, 0)->toDateTimeString())
            ->get();

        $count = 0;
        foreach($allProperties as $property)
        {
            ProcessPropertyUpdate::dispatch($property);
            $count++;
        }

        $this->output->newLine();
        $this->output->success($count . ' properties updated.');
        $this->output->newLine();

        return Command::SUCCESS;
    }
}
