<?php

namespace Netzperfekt\SaasProptrend\Enums;

use Filament\Support\Contracts\HasLabel;

enum FieldType: int implements HasLabel
{
    case Text       =  0;
    case Number     =  1;
    case Price      = 10;
    case Provision  = 11;
    case QmHouse    = 12;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Text      => __('proptrend-enum-fieldtype-text'),
            self::Number    => __('proptrend-enum-fieldtype-number'),

            self::Price     => __('proptrend-enum-fieldtype-price'),
            self::Provision => __('proptrend-enum-fieldtype-provision'),

            self::QmHouse   => __('proptrend-enum-fieldtype-qm-house'),
        };
    }

    public function getUnit(): ?string
    {
        return match ($this) {
            self::Text      => __('proptrend-enum-fieldtype-unit-text'),
            self::Number    => __('proptrend-enum-fieldtype-unit-number'),

            self::Price     => __('proptrend-enum-fieldtype-unit-price'),
            self::Provision => __('proptrend-enum-fieldtype-unit-provision'),

            self::QmHouse   => __('proptrend-enum-fieldtype-unit-qm-house'),
        };
    }
}