<?php

namespace Netzperfekt\SaasProptrend\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum ProjectType: int implements HasLabel, HasIcon
{
    case House = 10;
    case Flat  = 11;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::House => __('proptrend-enum-project-type-house'),
            self::Flat  => __('proptrend-enum-project-type-flat')
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::House => 'fas-house',
            self::Flat  => 'fas-building'
        };
    }

    public static function getDefaultFieldsFor($type)
    {
        if(ProjectType::from($type) == self::House)
        {
            return [
                ['id' => 'price',             'label' => 'Kaufpreis',              'type' => FieldType::Price],
                ['id' => 'qm_house',          'label' => 'Wohnfläche',             'type' => FieldType::QmHouse],
                ['id' => 'qm_area',           'label' => 'Grundstücksfläche',      'type' => FieldType::Number],
                ['id' => 'year_construction', 'label' => 'Baujahr',                'type' => FieldType::Number],
                ['id' => 'rooms',             'label' => 'Zimmer',                 'type' => FieldType::Number],
                ['id' => 'energy_source',     'label' => 'Energieträger',          'type' => FieldType::Text],
                ['id' => 'energy_consumption','label' => 'Energieverbrauch',       'type' => FieldType::Number],
                ['id' => 'energy_class',      'label' => 'Energieeffizienzklasse', 'type' => FieldType::Text],
                ['id' => 'provision',         'label' => 'Provisionshöhe',         'type' => FieldType::Provision],
                ['id' => 'estate_agent',      'label' => 'Maklername',             'type' => FieldType::Text]
            ];
        }

        else if(ProjectType::from($type) == self::Flat)
        {
            return [
                ['id' => 'price',             'label' => 'Kaufpreis',              'type' => FieldType::Price],
                ['id' => 'allowance',         'label' => 'Hausgeld',               'type' => FieldType::Number],
                ['id' => 'qm_house',          'label' => 'Wohnfläche',             'type' => FieldType::QmHouse],
                ['id' => 'qm_area',           'label' => 'Grundstücksfläche',      'type' => FieldType::Number],
                ['id' => 'year_construction', 'label' => 'Baujahr',                'type' => FieldType::Number],
                ['id' => 'rooms',             'label' => 'Zimmer',                 'type' => FieldType::Number],
                ['id' => 'energy_source',     'label' => 'Energieträger',          'type' => FieldType::Text],
                ['id' => 'energy_consumption','label' => 'Energieverbrauch',       'type' => FieldType::Number],
                ['id' => 'energy_class',      'label' => 'Energieeffizienzklasse', 'type' => FieldType::Text],
                ['id' => 'provision',         'label' => 'Provisionshöhe',         'type' => FieldType::Provision],
                ['id' => 'estate_agent',      'label' => 'Maklername',             'type' => FieldType::Text]
            ];
        }

        return [];
    }
}