<?php

namespace Netzperfekt\SaasProptrend\Enums;

use Filament\Support\Contracts\HasLabel;

enum PropHistoryType: int implements HasLabel
{
    case Update   =  0;
    case Removed  =  1;
    case Contact  = 10;
    case Note     = 20;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Update  => __('proptrend-enum-prophistory-type-update'),
            self::Removed => __('proptrend-enum-prophistory-type-removed'),
            self::Contact => __('proptrend-enum-prophistory-type-contact'),
            self::Note    => __('proptrend-enum-prophistory-type-note')
        };
    }
}