<?php

namespace Netzperfekt\SaasProptrend\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum PropStatus: int implements HasLabel, HasIcon, HasColor
{
    case Active      =   0;
    case NeedsReview =   1;
    case Inactive    =   2;
    case Removed     =   9;
    case Archived    =  99;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Active      => __('proptrend-enum-prop-status-active'),
            self::NeedsReview => __('proptrend-enum-prop-status-review'),
            self::Inactive    => __('proptrend-enum-prop-status-inactive'),
            self::Removed     => __('proptrend-enum-prop-status-removed'),
            self::Archived    => __('proptrend-enum-prop-status-archived'),
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::Active        => 'fas-circle-check',
            self::NeedsReview   => 'fas-clock',
            self::Inactive      => 'fas-circle-xmark',
            self::Removed       => 'fas-ban',
            self::Archived      => 'fas-box-archive',
        };
    }

    public function getColor(): ?string
    {
        return match ($this)
        {
            self::Active      => 'success',
            self::NeedsReview => 'danger',
            self::Inactive    => 'danger',
            self::Removed     => 'error',
            self::Archived    => 'gray',
        };
    }
}
